/*
 * Decompiled with CFR 0.152.
 */
package com.tsf.demo.provider.controller;

import brave.Span;
import brave.Tracing;
import brave.handler.MutableSpan;
import brave.propagation.TraceContext;
import com.tsf.demo.provider.config.ProviderNameConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.tsf.core.util.TsfSpringContextAware;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProviderController {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderController.class);
    @Autowired
    private ProviderNameConfig providerNameConfig;
    @Autowired
    private Tracing tracing;

    @RequestMapping(value={"/echo/{param}"}, method={RequestMethod.GET})
    public String echo(@PathVariable String param) {
        LOG.info("provider-demo -- request param: [" + param + "]");
        String result = "request param: " + param + ", response from " + this.providerNameConfig.getName();
        LOG.info("provider-demo -- provider config name: [" + this.providerNameConfig.getName() + ']');
        LOG.info("provider-demo -- response info: [" + result + "]");
        return result;
    }

    @RequestMapping(value={"/config/{path}/value"}, method={RequestMethod.GET})
    public String config(@PathVariable String path) {
        return TsfSpringContextAware.getProperties((String)path);
    }

    @RequestMapping(value={"/echo/error/{param}"}, method={RequestMethod.GET})
    public String echoError(@PathVariable String param) {
        LOG.info("provider-demo -- Error request param: [" + param + "], throw exception");
        throw new RuntimeException("mock-ex");
    }

    @RequestMapping(value={"/echo/slow/{param}"}, method={RequestMethod.GET})
    public String echoSlow(@PathVariable String param, @RequestParam(required=false) Integer delay) throws InterruptedException {
        int sleepTime = delay == null ? 1000 : delay;
        LOG.info("provider-demo -- slow request param: [" + param + "], Start sleep: [" + sleepTime + "]ms");
        Thread.sleep(sleepTime);
        LOG.info("provider-demo -- slow request param: [" + param + "], End sleep: [" + sleepTime + "]ms");
        String result = "request param: " + param + ", slow response from " + this.providerNameConfig.getName() + ", sleep: [" + sleepTime + "]ms";
        return result;
    }

    @RequestMapping(value={"/checkToken"}, method={RequestMethod.GET})
    public Map<String, Object> checkToken(@RequestParam String token) {
        LOG.info("provider-demo -- request param: [" + token + "]");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", "provider-demo".equalsIgnoreCase(token));
        resultMap.put("payload", "this is payload");
        LOG.info("provider-demo -- response info: [" + resultMap + "]");
        return resultMap;
    }

    @RequestMapping(value={"/printRequest"}, method={RequestMethod.GET})
    public Map<String, Object> printRequest(HttpServletRequest request) {
        LinkedHashMap<String, Object> requestMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        LinkedHashMap cookieMap = new LinkedHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headerMap.put(headerName, request.getHeader(headerName));
        }
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            parameterMap.put(paramName, request.getParameter(paramName));
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            Stream.of(cookies).forEach(e -> cookieMap.put(e.getName(), e.getValue()));
        }
        requestMap.put("Protocol", request.getProtocol());
        requestMap.put("Method", request.getMethod());
        requestMap.put("URL", request.getRequestURL());
        requestMap.put("Parameters", parameterMap);
        requestMap.put("Headers", headerMap);
        requestMap.put("Cookies", cookieMap);
        requestMap.put("OriginalCookies", cookies);
        return requestMap;
    }

    @RequestMapping(value={"/echoTracer/{param}"}, method={RequestMethod.GET})
    public String echoTracer(@PathVariable String param) throws Exception {
        TraceContext traceContext = this.tracing.tracer().currentSpan().context();
        long traceId = traceContext.traceId();
        long spanId = traceContext.spanId();
        LOG.info("traceId:{},spanId:{}", (Object)traceId, (Object)spanId);
        Span span = this.tracing.tracer().currentSpan();
        Field state = span.getClass().getDeclaredField("state");
        state.setAccessible(true);
        MutableSpan mutableSpan = (MutableSpan)state.get(span);
        Field tags = mutableSpan.getClass().getDeclaredField("tags");
        tags.setAccessible(true);
        ArrayList list = (ArrayList)tags.get(mutableSpan);
        String key = null;
        String value = null;
        int length = list.size();
        for (int i = 0; i < length; i += 2) {
            key = (String)list.get(i);
            value = (String)list.get(i + 1);
            LOG.info("tags key: {}, value: {}", (Object)key, (Object)value);
        }
        this.tracing.tracer().currentSpan().tag("key", "value");
        TraceContext context = traceContext.toBuilder().traceId(222L).spanId(111L).build();
        String result = "request param: " + param + ", response from " + this.providerNameConfig.getName();
        return result;
    }
}

