/*
 * Decompiled with CFR 0.152.
 */
package com.tsf.demo.consumer.schedule;

import com.tsf.demo.consumer.entity.CustomMetadata;
import com.tsf.demo.consumer.proxy.ProviderDemoService;
import com.tsf.demo.consumer.proxy.ProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.tsf.core.TsfContext;
import org.springframework.tsf.core.entity.Tag;

@EnableScheduling
@Service
public class ScheduledProviderDemo {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledProviderDemo.class);
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ProviderDemoService providerDemoService;

    @Scheduled(fixedDelayString="${consumer.auto.test.interval:1000}")
    public void doWork() throws InterruptedException {
        TsfContext.putTag((String)"test", (String)"123", (Tag.ControlFlag[])new Tag.ControlFlag[0]);
        TsfContext.putCustomMetadata((Object)new CustomMetadata("test", "123"));
        String response = this.providerDemoService.echo("auto-test");
        LOG.info("consumer-demo auto test, response: [" + response + "]");
    }

    public void doWorkFallback() {
        LOG.info("consumer-demo auto test fallback.");
    }
}

